<?php
require_once 'config.php';

session_start();
if (!isset($_SESSION['logged_in'])) {
    die('Acceso denegado');
}

$sql = "SELECT * FROM credenciales ORDER BY id DESC";
$result = mysqli_query($conn, $sql);

$data = array();
while($row = mysqli_fetch_assoc($result)) {
    $data[] = $row;
}

$export = array(
    'total_credenciales' => count($data),
    'fecha_exportacion' => date('Y-m-d H:i:s'),
    'credenciales' => $data
);

header('Content-Type: application/json');
header('Content-Disposition: attachment; filename="base_datos_' . time() . '.json"');
echo json_encode($export, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);

mysqli_close($conn);
?>